/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.blockentity;

import com.refinedmods.refinedpipes.blockentity.PipeBlockEntity;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.fluid.FluidNetwork;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipe;
import com.refinedmods.refinedpipes.network.pipe.fluid.FluidPipeType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class FluidPipeBlockEntity
extends PipeBlockEntity {
    private final FluidPipeType type;
    private FluidStack fluid = FluidStack.EMPTY;
    private float fullness = 0.0f;
    private float renderFullness = 0.0f;

    public FluidPipeBlockEntity(BlockPos pos, BlockState state, FluidPipeType type) {
        super(type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public float updateAndGetRenderFullness(float partialTicks) {
        float step = partialTicks * 0.05f;
        if (this.renderFullness > this.fullness) {
            this.renderFullness -= step;
            if (this.renderFullness < this.fullness) {
                this.renderFullness = this.fullness;
            }
        } else if (this.renderFullness < this.fullness) {
            this.renderFullness += step;
            if (this.renderFullness > this.fullness) {
                this.renderFullness = this.fullness;
            }
        }
        return this.renderFullness;
    }

    @Override
    public CompoundTag writeUpdate(CompoundTag tag) {
        Pipe pipe = NetworkManager.get(this.f_58857_).getPipe(this.f_58858_);
        if (pipe instanceof FluidPipe && pipe.getNetwork() != null) {
            tag.m_128365_("fluid", (Tag)((FluidNetwork)pipe.getNetwork()).getFluidTank().getFluid().writeToNBT(new CompoundTag()));
            tag.m_128350_("fullness", ((FluidPipe)pipe).getFullness());
        }
        return super.writeUpdate(tag);
    }

    @Override
    public void readUpdate(@Nullable CompoundTag tag) {
        this.fluid = tag != null && tag.m_128441_("fluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid")) : FluidStack.EMPTY;
        if (tag != null && tag.m_128441_("fullness")) {
            this.renderFullness = this.fullness = tag.m_128457_("fullness");
        } else {
            this.fullness = 0.0f;
            this.renderFullness = 0.0f;
        }
        super.readUpdate(tag);
    }

    public void setFullness(float fullness) {
        this.fullness = fullness;
    }

    @Override
    protected Pipe createPipe(Level level, BlockPos pos) {
        return new FluidPipe(level, pos, this.type);
    }
}

